/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/

#ifndef _TIMER_H
#define _TIMER_H

#include <stdlib.h>
#include <time.h>

#if !defined (_WIN32_WCE) && !defined (WIN32)
#include <sys/time.h>
#else
#include <Winsock.h>
#endif

typedef void (*timer_cb_t) (void *);

typedef struct _TIMER
{
    unsigned int interval;
    int		events;
    timer_cb_t	func;
    void	*arg;
    struct timeval next_time;
    unsigned int refnum;
    struct _TIMER *next;
} TIMER;

#define timer_now(n) gettimeofday(n,NULL);

int  next_timer (struct timeval *, struct timeval *);
unsigned int add_timer (unsigned int, int, timer_cb_t, void *);
void exec_timers (struct timeval *);
void free_timers (void);
void timer_reschedule (unsigned int, int);
void timer_remove(unsigned int);
void timer_exec_now(unsigned int refnum);
void timer_set_interval (unsigned int refnum, int interval);
#endif
