/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/

#ifndef _GPIO_H
#define _GPIO_H

#if !defined(_WIN32_WCE) && !defined(WIN32)
typedef int HANDLE; /* to have a uniform handler type presentation */
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*	close the GPIO handle
	<fd> file descriptor
*/
void mxgpio_close(int fd);

/*  open an access to the GPIO ports
    Inputs:
		None
	Returns:
		a file descriptor
*/
HANDLE mxgpio_open(void);

/*  get the current mode of a GPIO pin
    Inputs:
        <fd> the file descriptor
        <pin> pin #
    Returns:
        the mode
*/
int mxgpio_get_mode(HANDLE fd, int pin);

/*  get the current value of a GPIO pin
    Inputs:
        <fd> the file descriptor
        <pin> pin #
    Returns:
        the value
*/
int mxgpio_get_data(HANDLE fd, int pin);

/*  set the current mode of a GPIO pin
    Inputs:
        <fd> the file descriptor
        <pin> pin #
        <mode> mode
    Returns:
        the mode
*/
int mxgpio_set_mode(HANDLE fd, int pin, int val);

/*  set the current value of a GPIO pin
    Inputs:
        <fd> the file descriptor
        <pin> pin #
    Returns:
        the value
*/
int mxgpio_set_data(HANDLE fd, int pin, int val);

#ifdef __cplusplus
}
#endif

#endif

