/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/
/*
    mxdgio.c

	Routines to operate the digit I/O in an embedded computer.

    2010-07-06	new release
*/
#include <windows.h>


#define GPD_TYPE 40000

#if defined(DA683) || defined(DA710)
#define DIO_DEV_NAME	L"\\\\.\\DIODev"

// The IOCTL function codes from 0x800 to 0xFFF are for customer use.
// The IOCTL function codes from 0x800 to 0xFFF are for customer use.
#define IOCTL_SET_DOUT_ALL \
    CTL_CODE( GPD_TYPE, 0x899, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_SET_DOUT \
    CTL_CODE( GPD_TYPE, 0x900, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_GET_DOUT \
    CTL_CODE( GPD_TYPE, 0x901, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_GET_DIN \
    CTL_CODE( GPD_TYPE, 0x902, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_GET_DIN_ALL \
    CTL_CODE(GPD_TYPE,  0x903, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_GET_DOUT_ALL \
    CTL_CODE(GPD_TYPE,  0x904, METHOD_BUFFERED, FILE_READ_ACCESS)
#else
#define DIO_DEV_NAME	L"\\\\.\\mxdgio"
#define MOXA_DIO_IOCTL 0x900 

#define IOCTL_SET_DOUT_ALL \
    CTL_CODE( GPD_TYPE, MOXA_DIO_IOCTL, METHOD_BUFFERED, FILE_ANY_ACCESS ) //0x900

#define IOCTL_GET_DOUT_ALL \
    CTL_CODE(GPD_TYPE,  MOXA_DIO_IOCTL+1, METHOD_BUFFERED, FILE_ANY_ACCESS)//0x901

#define IOCTL_SET_DOUT \
    CTL_CODE( GPD_TYPE, MOXA_DIO_IOCTL+2, METHOD_BUFFERED, FILE_ANY_ACCESS )//0x902

#define IOCTL_GET_DOUT \
    CTL_CODE( GPD_TYPE, MOXA_DIO_IOCTL+3, METHOD_BUFFERED, FILE_ANY_ACCESS )//0x903

#define IOCTL_GET_DIN_ALL \
    CTL_CODE(GPD_TYPE,  MOXA_DIO_IOCTL+4, METHOD_BUFFERED, FILE_ANY_ACCESS) //0x904

#define IOCTL_GET_DIN \
    CTL_CODE( GPD_TYPE, MOXA_DIO_IOCTL+5, METHOD_BUFFERED, FILE_ANY_ACCESS ) //0x905
#endif


typedef struct _DGTIO {
	int	port;
	int	data;
} DGTIO, *PDGTIO;


/*	open a dio handle for later uses
	Inputs:
		none
	Returns:
		pointer to a dio handle. Return 0 on failure.
*/
HANDLE mxdgio_open(void)
{
	HANDLE hDIO = CreateFile (DIO_DEV_NAME, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
	return hDIO;
}

/*	close a dio handle
	Inputs:
		<fd> the handle
	Returns:
		none
*/
void mxdgio_close(HANDLE fd)
{
	HANDLE hDIO;
	hDIO=fd;
	CloseHandle(hDIO);
	return;
}

/*	set the value (HIGH or LOW) of dio port
	Inputs:
		<fd>	the dio handle
		<port_no> the port number (started from 0)
		<data>    1:HIGH, 0:LOW
	Returns:
		0 on success, otherwise the function fails
*/
int mxdgio_set_output_signal_high(HANDLE fd, unsigned int port)
{
	HANDLE hDIO;
	
	DGTIO dio;
	DWORD dwBackSize = 0;
	int ret = 0;

	hDIO = fd;
	dio.port = port;
	dio.data = 1;
	ret = DeviceIoControl(hDIO, IOCTL_SET_DOUT, (void*)&dio, sizeof(DGTIO), 
				NULL, 0, &dwBackSize, NULL);

	/*Wait for writing the data*/
	Sleep(50);

	if(!ret)
		ret=-1;
	return ret;
}

/*	set the value (HIGH or LOW) of dio port
	Inputs:
		<fd>	the dio handle
		<port_no> the port number (started from 0)
		<data>    1:HIGH, 0:LOW
	Returns:
		0 on success, otherwise the function fails
*/
int mxdgio_set_output_signal_low(HANDLE fd, unsigned int port)
{
	HANDLE hDIO;
	
	DGTIO dio;
	DWORD dwBackSize=0;
	int ret=0;

	hDIO = fd;
	dio.port = port;
	dio.data = 0;
	ret = DeviceIoControl(hDIO, IOCTL_SET_DOUT, (void*)&dio, sizeof(DGTIO), 
				NULL, 0, &dwBackSize, NULL);

	/*Wait for writing the data*/
	Sleep(50);
	
	if(!ret)
		ret=-1;
	return ret;
}

/*	get the value (HIGH or LOW) of dio port
	Inputs:
		<fd>	the dio handle
		<port_no> the port number (started from 0)
	Returns:
		1 indicates HIGH, 0 indicates LOW, otherwise the function fails
*/
int mxdgio_get_input_signal(HANDLE fd, int port)
{

	HANDLE hDIO;
	DGTIO dio;
	int din = 0;
	DWORD dwBackSize=0;
	int ret=0;

	hDIO = fd;
	dio.port = port;
	if (!DeviceIoControl(hDIO, IOCTL_GET_DIN, (void*)&dio, sizeof(DGTIO), 
				(void*)&din, sizeof(int), &dwBackSize, NULL))
		return -1;

	return din;
}

/*	get the value (HIGH or LOW) of dio port
	Inputs:
		<fd>	the dio handle
		<port_no> the port number (started from 0)
	Returns:
		1 indicates HIGH, 0 indicates LOW, otherwise the function fails
*/
int mxdgio_get_output_signal(HANDLE fd, int port)
{

	HANDLE hDIO;
	DGTIO dio;
	int din = 0;
	DWORD dwBackSize=0;
	int ret=0;

	hDIO = fd;
	dio.port = port;
	if (!DeviceIoControl(hDIO, IOCTL_GET_DOUT, (void*)&dio, sizeof(DGTIO), 
				(void*)&din, sizeof(int), &dwBackSize, NULL))
		return -1;

	return din;
}

