/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/
/*
    mxthread_win.c

    Routines to handle pipes.

    2009-01-15	CF Lin
		new release
*/
#include <windows.h>
#include <winbase.h>
#include <stdio.h>
#include "mxthread.h"

HANDLE
mxthread_create(thread_cb_t cb, void *arg)
{
	HANDLE hThread;
	DWORD thread_id;

	hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE ) cb, (LPVOID) arg, 0, (DWORD*) &thread_id);

	return hThread;
}

int
mxthread_close(HANDLE hThread)
{
	if( CloseHandle(hThread) == 0 )
		return -1;
	return 0;
}

