/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/
/*
    getopt.c

    Routines of parsing command line arguments

    2008-08-15	CF Lin
		new release
*/

#include <string.h>

#ifndef EOF
#define EOF -1
#endif

int optind = 1;
char *optarg;

/* -b 500 -v */
int
_getopt (int ac, char **av, const char *opts)
{
    const char *p;

    while (optind < ac)
    {
	if (*av[optind] == '-')
	{
	    p = strchr (opts, av[optind][1]);
	    if (!p)
		return '?';
	    if (*(p + 1) == ':')
	    {
		/* requires arg */
		optind++;
		if (!av[optind] || *av[optind] == '-')
		    return ':';	/* missing argument */
		optarg = av[optind];
	    }
	    else
		optarg = 0;
	    optind++;
	    return *p;
	}
	else
	    break;
    }
    optarg = 0;
    return EOF;
}
