/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/
/*
    mcast_server.c

    This is a simple multicast server program.

    2009-11-03 Peter Wu new release
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mcast.h"

#if defined(WIN32) || defined(_WIN32_WCE)
#include <windows.h>
#else
#include <unistd.h>
#include <errno.h>
#endif
#include "network.h"

#if defined(WIN32) || defined(_WIN32_WCE)
#define errno	WSAGetLastError()
typedef int socklen_t;
#else
#define SOCKET_ERROR	-1
#endif

int
#ifdef _WIN32_WCE
WINAPI
WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
#else
main(int argc, char *argv[])
#endif
{
	SOCKET fd;
	struct sockaddr_in servaddr;
	struct ip_mreq mreq;
	socklen_t salen;
	char buf[1024];
	int msgLen;
#if defined(_WIN32_WCE)
	int argc;
	char cmdline[256], *argv[32];

	WideCharToMultiByte(CP_ACP, 0, (LPCTSTR)lpCmdLine, 255, cmdline, 256, NULL, NULL);
	argc = split_line(argv+1, 32, cmdline)+1;
#endif

	if (argc < 3) {
		printf("Usage: %s mcast_ip port\n", argv[0]);
		exit(1);
	}
#ifdef WIN32
#ifndef _WIN32_WCE
	/* When a TCP/IP host starts, it sends a host membership report to the */
	/* all-hosts group (224.0.0.1) from each network interface to notify */
	/* the multicast routers. */
	if (!strcmp(argv[1], "224.0.0.1")) {
		printf("Illegal multicast IP\n");
		exit(2);
	}
#endif
#endif

	net_library_init();

	if ((fd = mcast_make_server(argv[1], atoi(argv[2]), &servaddr)) < 0) {
		printf("mcast_make_server() error %d\n", fd);
		return -3;
	}

	if (mcast_join(fd, argv[1], &mreq) < 0) {
		printf("mcast_join() error\n");
		return -4;
	}

	while (1) {
		/* blocking mode */
#if 0
		memset(&servaddr, 0x0, sizeof(servaddr));
#endif
		salen = sizeof(servaddr);
		if ((msgLen = recvfrom(fd, buf, sizeof(buf)-1, 0,
					(struct sockaddr *)&servaddr, &salen)) == SOCKET_ERROR) {
			printf("recvfrom() error %d\n", errno);
			break;
		}

		buf[msgLen] = 0;
		printf("multicast msg %s len %d\n", buf, msgLen);
	}

	if (mcast_leave(fd, &mreq) < 0) {
		printf("mcast_leave() error\n");
	}

	closesocket(fd);
	net_library_release();

	return 0;
}
