/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/
/*
    msnd.c

    This is a simple multicast client program.

    2009-11-03 Peter Wu	new release
*/
#include <stdio.h>
#include <stdlib.h>
#include "network.h"
#include "mcast.h"

int
#if defined(_WIN32_WCE)
WINAPI
WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
#else
main (int argc, char **argv)
#endif
{
	SOCKET fd;
	int onoff;
	char buf[256];
	int msglen;
	int i = 0;
	struct sockaddr_in addr;
#if 0
	int salen;
#endif
#if defined(_WIN32_WCE)
	int argc;
	char cmdline[256], *argv[32];

	WideCharToMultiByte(CP_ACP, 0, (LPCTSTR)lpCmdLine, 255, cmdline, 256, NULL, NULL);
	argc = split_line(argv+1, 32, cmdline)+1;
#endif

	if (argc < 3)
	{
		printf("usage: mcast_client <mcast_ip> <port> [loopback]\n");
		return -1;
	}
	if (argc > 3) onoff = atoi(argv[3]);
	else onoff = 0;

	net_library_init();

	if ((fd = mcast_make_client(onoff, argv[1], atoi(argv[2]), &addr)) < 0)
	{
		printf("mcast_make_client() error %d\n", fd);
		net_library_release();
		return -1;
	}
#if 0
	salen = sizeof(struct sockaddr_in);
#endif
	while (1)
	{
		sprintf(buf, "Hello world %d", i);
		msglen = strlen(buf);
		i++;
#if 1
		if (udp_send(fd, buf, msglen, &addr) < 0)
#else
		if (sendto(fd, buf, msglen, 0,
					(struct sockaddr *)&addr, salen) == -1)
#endif
		{
			printf("udp_send() error\n");
			break;
		}
#if defined(_WIN32_WCE) || defined(WIN32)
		Sleep(500);
#else
		sleep(1);
#endif
		printf("%s\n", buf);
	}
	closesocket(fd);
	net_library_release();
	return 0;
}
