/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/
/*
    mxrtc_wce.c

    Routines to handle rtc.

    2009-01-15	CF Lin
		new release
*/
#include <stdio.h>
#include <Winbase.h>

#ifndef CTL_CODE
#define CTL_CODE( DeviceType, Function, Method, Access ) (                 \
    ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
)
#endif

#define FILE_DEVICE_HAL		0x00000101
#define FILE_ANY_ACCESS     0
#define METHOD_BUFFERED     0


#if defined (UC712X) /* WINCE6 *********************************/
#define KRNIOCTL_RTC_GET	CTL_CODE(FILE_DEVICE_HAL, 14, METHOD_BUFFERED, FILE_ANY_ACCESS)
#elif defined (IA26X) /* WINCE6 *********************************/
#define IOCTL_RTC_GET		CTL_CODE( 0, 995, 0, 0)
#else /* UC74XX/DA66X WINCE5 *********************************/
#define IOCTL_RTC_GET		CTL_CODE( 0, 43, 0, 0)
#define IOCTL_RTC_SET		CTL_CODE( 0, 42, 0, 0)

#define RTC_FILE_NODE		L"RTC1:"

#endif		/* end _UC712X */

#ifndef RTC_FILE_NODE
#define RTC_FILE_NODE		L"UCS1:"
#endif

/*	for UC74XX and DA66X only, the newer devices will sync RTC time while set system time	*/

/*
*/
int
mxrtc_set(unsigned int *timeA)
{
	SYSTEMTIME systemTime;
	DWORD size = sizeof(SYSTEMTIME);
	int st = 0;

	memset(&systemTime, 0, size);
	systemTime.wYear	= timeA[0];
	systemTime.wMonth	= timeA[1]; 
	systemTime.wDay		= timeA[2]; 
	systemTime.wHour	= timeA[3]; 
	systemTime.wMinute	= timeA[4]; 
	systemTime.wSecond	= timeA[5];

#if defined(IOCTL_RTC_SET)
	{
		HANDLE hRTC;
		DWORD dwBackSize;

		hRTC = CreateFile ( RTC_FILE_NODE, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
		if (hRTC == INVALID_HANDLE_VALUE)
			return -1; 
		DeviceIoControl(hRTC, IOCTL_RTC_SET, (void*) &systemTime, size, NULL, 0, &dwBackSize, NULL);
		CloseHandle (hRTC);
	}
#else
	SetSystemTime(&systemTime);
#endif
	return st;
}

int
mxrtc_get(unsigned int *timeA)
{
	SYSTEMTIME systemTime;
	DWORD size = sizeof(SYSTEMTIME);
	int st = 0;

	memset(&systemTime, 0, size);
#if defined(IOCTL_RTC_GET)
	{
		HANDLE hRTC;
		DWORD dwBackSize;
		hRTC = CreateFile ( RTC_FILE_NODE, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
		if (hRTC == INVALID_HANDLE_VALUE)
			st = -1;
		else
		{
			DeviceIoControl(hRTC, IOCTL_RTC_GET, NULL, 0,  (void*) &systemTime, size, &dwBackSize, NULL);
			CloseHandle (hRTC);
		}
	}
#elif defined(KERNAL_IOCTL_RTC_SET)
		kernel_ioctl(RTC_KERNAL_IOCTL_SET, &systemTime, &size);
#else
		GetSystemTime(&systemTime);
#endif

	timeA[0] = systemTime.wYear;
	timeA[1] = systemTime.wMonth; 
	timeA[2] = systemTime.wDay; 
	timeA[3] = systemTime.wHour; 
	timeA[4] = systemTime.wMinute; 
	timeA[5] = systemTime.wSecond;
	return st;
}

int 
mxrtc_set_system_time(void)
{
	SYSTEMTIME systemTime;
	unsigned int timeA[6];
	
	if (mxrtc_get(timeA))
		return -1;
	systemTime.wYear	= timeA[0];
	systemTime.wMonth	= timeA[1]; 
	systemTime.wDay		= timeA[2]; 
	systemTime.wHour	= timeA[3]; 
	systemTime.wMinute	= timeA[4]; 
	systemTime.wSecond	= timeA[5];
	SetSystemTime(&systemTime);
	return 0;
}

int 
mxrtc_get_system_time(void)
{
	SYSTEMTIME systemTime;
	unsigned int timeA[6];
	
	GetSystemTime(&systemTime);
	timeA[0] = systemTime.wYear;
	timeA[1] = systemTime.wMonth; 
	timeA[2] = systemTime.wDay; 
	timeA[3] = systemTime.wHour; 
	timeA[4] = systemTime.wMinute; 
	timeA[5] = systemTime.wSecond;

	return mxrtc_set(timeA);
}
