/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/

/*
    mxbuzzer.c

    Routines to operate the buzzer in an embedded computer.

    2008-08-20
*/
#include	<windows.h>
#include	"mxbuzzer.h"

#ifdef CTL_CODE
#undef CTL_CODE
#endif

#define CTL_CODE(DeviceType, Function, Method, Access) ( \
  ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
)

#if defined(UC74XX) || defined (DA66X)
#define IOCTL_GPIO_BEEP_ON		CTL_CODE( 0, 106, 0, 0)
#else /* IA26X, UC-712X */
#define IOCTL_BUZZER_ON			CTL_CODE( 0, 167, 0, 0)
#define IOCTL_BUZZER_OFF 		CTL_CODE( 0, 168, 0, 0)
#endif

#if defined(UC74XX) || defined (DA66X)
typedef struct   _MXBEEP 
{
	unsigned int  uFreq;
	unsigned int  uMilliSec;
} MXBEEP;
#endif

HANDLE
mxbuzzer_open (void)
{
	HANDLE fd;

#if defined(UC74XX) || defined (DA66X)
	fd = CreateFile (L"PIO1:", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
#else /* IA26X, UC-712X */
	fd = CreateFile (L"UCS1:", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
#endif
	if (fd==INVALID_HANDLE_VALUE)
		return NULL;
	else
		return fd;
}

void
mxbuzzer_beep (HANDLE hBuzzer, int time, int freq)
{
#if defined(UC74XX) || defined (DA66X)
	MXBEEP b;

	b.uFreq = freq;
	b.uMilliSec = time;
	if ( hBuzzer != INVALID_HANDLE_VALUE)
	{
		DeviceIoControl(hBuzzer, IOCTL_GPIO_BEEP_ON, (LPVOID*) &b, sizeof (MXBEEP), NULL, 0, NULL, NULL);
	}
#else /* IA26X, UC-712X */
	DeviceIoControl (hBuzzer, IOCTL_BUZZER_ON, NULL, 0, NULL, 0,  NULL, NULL);
	Sleep(time);
#endif
}

void
mxbuzzer_close (HANDLE hBuzzer)
{
#if !defined(UC74XX) && !defined (DA66X) /* IA26X, UC-712X */
	DeviceIoControl (hBuzzer, IOCTL_BUZZER_OFF, NULL, 0, NULL, 0,  NULL, NULL);
#endif
	CloseHandle	(hBuzzer);
}
