/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/

#include "common.h"

/*  create a TCP server which waits for client connections
    Inputs:
		<param> point to its parameters
		<funs> point to its user-defined functions
	Returns:
		a handler to its connection on success, otherwise NULL for failure  
*/
MHANDLE tcp_connection_startup_server (SRVRPRM *param, USERFUN *funs);

/*	make a TCP client connection to a server
	Inputs:
		<param> point to its parameters
		<funs> point to its user-defined functions
	Returns:
		a handler to its connection on success, otherwise NULL for failure  
*/
MHANDLE tcp_connection_make_client (CLNTPRM *param, USERFUN *funs);

/*	create a UDP server which waits for client connections
	Inputs:
		<param> point to its parameters
		<funs> point to its user-defined functions
	Returns:
		a handler to its connection on success, otherwise NULL for failure  
*/
MHANDLE udp_connection_startup_server (UDPXPRM *param, USERFUN *funs);

/*	make a UDP client connection to a server
	Inputs:
		<param> point to its parameters
		<funs> point to its user-defined functions
	Returns:
		a handler to its connection on success, otherwise NULL for failure  
*/
MHANDLE udp_connection_make_client (UDPXPRM *param, USERFUN *funs);

/*	open a serial port connection
	Inputs:
		<param> point to its parameters
		<funs> point to its user-defined functions
	Returns:
		a handler to its connection on success, otherwise NULL for failure  
*/
MHANDLE mxsp_connection_open (UARTPRM *param, USERFUN *funs);


MHANDLE
connection_open(unsigned int type, void *param, USERFUN *funs, void **private_data)
{
	CONNPRT *conp=NULL;

dbgprintf("++connection_open:");
	switch (type)
	{
	case CONNECTION_TYPE_UARTPORT:
		conp = mxsp_connection_open ((UARTPRM*) param, funs);
		break;
	case CONNECTION_TYPE_TCPCLIENT:
		conp = tcp_connection_make_client ((CLNTPRM*) param, funs);
		break;
	case CONNECTION_TYPE_TCPSERVER:
		conp = tcp_connection_startup_server ((SRVRPRM*) param, funs);
		break;
	case CONNECTION_TYPE_UDPSERVER:
		conp = udp_connection_startup_server ((UDPXPRM*) param, funs);
		break;
	case CONNECTION_TYPE_UDPCLIENT:
		conp = udp_connection_make_client ((UDPXPRM*) param, funs);
		break;
	}
	if (conp && private_data)
	{
		*private_data = conp->private_data;
	}
dbgprintf("--connection_open:");
	return conp;
}

