#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "netiface.h"

int
main(int argc, char *argv[])
{
	MXIFACE iface;
	int rc;
	char *dns_list = NULL;


	if (argc < 3) {
		printf("Usage: netiface_set <iface> {0:dhcp|1:fixed ip} {1:<IP> <netmask> [gateway]} [DNS]\n");
		exit(-1);
	}
	memset(&iface, 0, sizeof(MXIFACE));
	strcpy(iface.ifname, argv[1]);
	iface.enable_dhcp = atoi(argv[2]) ? 0 : 1;
	if (!iface.enable_dhcp)
	{
		strcpy(iface.ipaddr, argv[3]);
		strcpy(iface.netmask, argv[4]);
		if (argc > 5) strcpy(iface.gateway, argv[5]);
	}
	if (mxiface_update_info(&iface) < 0) {
		printf("mxiface_update_info() error\n");
		exit(-2);
	}
	else printf("mxiface_update_info() OK\n");

	/* get dns list */
	if (iface.enable_dhcp && argc > 3)
		dns_list = argv[3];
	else if (!iface.enable_dhcp && argc > 6)
		dns_list = argv[6];

	if (dns_list)
	{
		if ((rc = mxiface_update_dns(iface.ifname, dns_list)) < 0)
			printf("mxiface_update_dns() error %d\n", rc);
		else
			printf("mxiface_update_dns() OK\n");
	}

	return 0;
}
