/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/

#include <stdio.h>
#if !defined( _WIN32_WCE) && !defined(WIN32)
#include <unistd.h>
#endif
#include "mxbuzzer.h"

int
#if defined(_WIN32_WCE)
WINAPI
WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
#else
main(int argc, char *argv[])
#endif
{
    int i;
   	HANDLE fd;

#if !defined( _WIN32_WCE) && !defined(WIN32)
    (void) argc;
    (void) argv;
#endif
	
	/* open the handle to the buzzer device */
    fd = mxbuzzer_open();
    if (fd < 0)
    {
        printf("fail to open the buzzer\n");
		return -1;
    }
#if !defined(_WIN32_WCE) && !defined(WIN32)
    i = 0;
    while (i++ < 10)
    {
		/* sound the buzzer */
		mxbuzzer_beep(fd, i*100);
		sleep(i);
    }
#else
#if defined(UC74XX) || defined(DA66X)
    i = 0;
    while (i++ < 10)
    {
		/* sound the buzzer */
		mxbuzzer_beep(fd, i*1000, 500);
		Sleep(i*1000);
    }
#else /* IA26X */
    i = 3;
	mxbuzzer_beep(fd, i*1000, 500);
#endif
#endif
	/* close the handle */
    mxbuzzer_close(fd);
    return 0;
}
