#ifndef _REGISTRY_H
#define _REGISTRY_H

#include <windows.h>
#include <Winreg.h>

typedef void (*registry_t) (TCHAR *tval, DWORD dwLenVal, TCHAR *tdat, DWORD dwLenDat, void *arg);

#define wchar2mbyte(x, y, z) WideCharToMultiByte(CP_ACP, 0, x, -1, y, z, NULL, NULL)
#define mbyte2wchar(x, y, z) MultiByteToWideChar(CP_ACP, 0, x, -1, y, z)

/* Obtain a registry value
	Inputs:
		<path> the path of the registry
		<key> the key under the path
		<size> the length of the value buffer
	Outputs:
		<val> the value buffer
	Returns:
		0 for success; others for failure
*/
int
registry_machine_get(TCHAR *path, TCHAR *key, TCHAR *val, DWORD size);

/* Update/Insert a registry value
	Inputs:
		<path> the path of the registry
		<key> the key under the path
		<szName> the value
		<type> the type of the registry
	Returns:
		0 for success; others for failure
*/
int
registry_machine_update(TCHAR *path, TCHAR *key, TCHAR *val, DWORD type, int sz);

/* make a function call upon each registry value under a path
	Inputs:
		<path>	the path
		<cb>	the callback function
		<arg>	the argument passed to the callback function
	Returns:
		0 for success; others for failure
*/
int
registry_machine_foreach(TCHAR *path, registry_t cb, void *arg, BOOL clean);

int
registry_machine_find_name(TCHAR *path, TCHAR *data, TCHAR *name, int sz);

#ifndef WINCE
int
registry_machine_find_data(TCHAR *path, TCHAR *AdapterName, TCHAR *subpath, TCHAR *Name, TCHAR *NetName);
#endif

#endif /* _REGISTRY_H */
