
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "modbus.h"

/* 	digest a MODBUS TCP ADU data packet into a TCP PDU structured buffer.
		ADU: <trans_identifier:2><proto_identifier:2><length:2><PDU>
	Note: PDU includes Unit Identifier field
	Inputs:
		<packet> ADU data packet
		<plen> the length of data packet
	Outputs:
		<tcp> PDU header
		<plen> the # of bytes that have consumed from the data packet
	Returns:
		pointer to the PDU of the TCP ADU inside the data packet
*/
unsigned char*
mbtcp_packet_digest(unsigned char *packet, unsigned int *plen, MBTCPHDR *tcp)
{
	unsigned short val;
	int len;

	if (*plen < 6)
		return NULL;

	memcpy(&val, packet+4, 2);
	len = BSWAP16(val);
	if (*plen < (unsigned int) (len+6)) /* not yet */
	{
#ifdef MDEBUG
		printf("mbtcp len=%d\n", len);
#endif
		return NULL;
	}
	else
	{
		memcpy(&val, packet, 2);
		tcp->trans_identifier = BSWAP16(val);
		memcpy(&val, packet+2, 2);
		tcp->proto_identifier = BSWAP16(val);
		tcp->length = len;
		*plen = (unsigned int) (len+6);
		return (packet+6);
	}
}

/* 	format data and a PDU header into a MODBUS TCP ADU data packet.
		<trans_identifier:2><proto_identifier:2><length:2><PDU>
	Note: PDU includes Unit Identifier field
	Inputs:
		<tcp> PDU header
		<data> data
		<len> the length of data
	Outputs:
		<packet> ADU data packet
	Returns:
		the # of bytes of the ADU packet
*/
unsigned int
mbtcp_packet_format(MBTCPHDR *tcp, unsigned char *data, unsigned int len, unsigned char *packet)
{
	unsigned short val;

	tcp->length = (unsigned short) len;
	val = BSWAP16(tcp->trans_identifier);
	memcpy(packet, &val, 2);
	val = BSWAP16(tcp->proto_identifier);
	memcpy(packet+2, &val, 2);
	val = BSWAP16(tcp->length);
	memcpy(packet+4, &val, 2);
	memcpy(packet+6, data, len);
	return len+6;
}
