/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/
/*
    moxa_config.c

    Routines related to MOXA devices.

    2008-04-15	CF Lin
		new release
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#if !defined( _WIN32_WCE) && !defined(WIN32)
#include <sys/stat.h>
#endif
#include "os-support.h"

int MOXA_1ST_UART_PORT = 99;
int gMaxSerialPorts = 0;

#if !defined( _WIN32_WCE) && !defined(WIN32)

int
mxsp_get_max_port(void)
{
       char ttyname[64];
       struct stat st;
       int port;

#ifdef W406
       for (port = 0; port < 2; port++)
#elif defined(W315)
       for (port = 0; port < 1; port++)
#else
       for (port = 0; port < 16; port++)
#endif
       {
        	sprintf(ttyname, "/dev/ttyM%d", port);
			if (stat(ttyname, &st))
				break;
			if (port < MOXA_1ST_UART_PORT) MOXA_1ST_UART_PORT = port;
       }
       return port;
}

#elif defined( _WIN32_WCE)

int
mxsp_get_max_port(void)
{
	DEVMGR_DEVICE_INFORMATION dev;
	HANDLE	fDevice = NULL;
	wchar_t *p;
	int	num = 0;

	dev.dwSize = sizeof(DEVMGR_DEVICE_INFORMATION);
	fDevice = FindFirstDevice(  DeviceSearchByDeviceName, L"COM*",  &dev );
//		fDevice = FindFirstDevice(  DeviceSearchByBusName, L"*",  &dev );
#ifdef W406
	while ( fDevice && num < 2)
#else
	while ( fDevice )
#endif
	{
		p = wcsstr( dev.szDeviceName, L"COM" );
		if ( p && (wcsstr(dev.szDeviceKey, L"MU860") || wcsstr(dev.szDeviceKey, L"MU150")) )
		{
			long com = wcstol( p+3, NULL, 10 );

			if (com < MOXA_1ST_UART_PORT) MOXA_1ST_UART_PORT = com;
			num++;
		}
		if ( !FindNextDevice(fDevice, &dev ) )
			break;
	}
	return num;
}

#else

#if 1
int
mxsp_get_max_port(void)
{
	MOXA_1ST_UART_PORT	= 1;
	return 16;
}
#else

static char *muTypes[] = 
{ 
	"Mxser", "Mxiser" 
};

#define NumOfModule 2
#define NumOfPort   8

int 
mxsp_get_max_port(void)
{
	char   *p, portName[20], wKeyName[32];
	int	   i, nModule,nPort,num = 0;

	for (i = 0; i < sizeof(muTypes)/sizeof(muTypes[0]); i++)
	{
		/* Search MU COM ports on modules */
		for(nModule=0;nModule<NumOfModule;nModule++)
		for(nPort=0;nPort<NumOfPort;nPort++)
		{
			snprintf(wKeyName, 32, "\\Device\\%sB0%dP00%d", muTypes[i], nModule, nPort);
			if (registry_machine_get("HARDWARE\\DEVICEMAP\\SERIALCOMM", wKeyName, portName, 20))
				return num;

			p = strstr( portName, "COM" );
			if (p)
			{
				long com = strtol( p+3, NULL, 10 );

				if (com < MOXA_1ST_UART_PORT) MOXA_1ST_UART_PORT = com;
					num++;
			}
		}
	}
	return num;
}
#endif
#endif

/* build code: V1.0 Build YYMMDDHH */
int
get_program_build_time(char *ver, char *buffer)
{
	int i, ac = 0;
	char dateTime[128], *av[8], *p;
	static char *months[] = {
		"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};

	strcpy(buffer, ver);
	/* example> May 15 2007 16:55:34 */
	snprintf(dateTime, 128,"%s %s",__DATE__ , __TIME__);
	p = dateTime;
	while(1)
	{
		while(*p && isspace(*p)) p++;
		if (*p==0)
			break;
		av[ac++] = p;
		p = strchr(p, ' ');
		if (!p)
			break;
		*p = 0;
		p++;
	}

	if (ac > 3)
	{
		for (i=0; i < 12; i++)
		{
			if (strncasecmp(months[i], av[0], 3)==0)
				break;
		}
		if (i<12)
		{
			p = strchr(av[3],':');
			if (p) *p = 0;
			sprintf(buffer+strlen(buffer), " Build %s%02d%02d%02d", av[2]+2, i+1, atoi(av[1]), atoi(av[3]));
		}
		return 0;
	}
	else
		return -1;
}

int	
moxa_device(void)
{
	gMaxSerialPorts = mxsp_get_max_port();
	if (gMaxSerialPorts==0)
	{
 		dbgprintf("device error");
		return 0;
	}
	else
	{
#if 0
		char mac_addr[8];

		return (mac_addr[0]==0x00 && mac_addr[1]==0x90 && mac_addr[2]==0xe8);
#else
		return 1;
#endif
	}
}
