/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/

#ifndef _BUFFER_H_
#define _BUFFER_H_

#define BUFFER_SIZE 4096	/* default buffer length for output queues */

typedef struct _BUFFER
{
    char    data[BUFFER_SIZE];		/* allocated data */
    int     datasize;		/* total bytes used in `data' */
    int     datamax;		/* size of allocated memory block */
    int     consumed;		/* how many bytes of data consumed from this buffer */
    struct _BUFFER *next;
} BUFFER;

BUFFER *buffer_new(void);
BUFFER *buffer_append (BUFFER *, BUFFER *);
BUFFER *buffer_consume (BUFFER *, int);
BUFFER *buffer_queue (BUFFER * b, char *d, int dsize);
void    buffer_free (BUFFER *);
int     buffer_size (BUFFER *);

#endif

