#include <string.h>
#include <stdlib.h>
#include "buffer.h"

BUFFER*
buffer_new(void)
{
	BUFFER *b;

	b = (BUFFER*) calloc(1,sizeof(BUFFER));
	if (b)
	{
		b->datamax = BUFFER_SIZE;
		b->datasize = 0;
		b->consumed = 0;
	}
	return b;
}

/* append bytes to the buffer */
BUFFER *
buffer_queue (BUFFER * b, char *d, int dsize)
{
    BUFFER *r = b;
    int     count;

    if (b)
	while (b->next)
	    b = b->next;
    while (dsize > 0)
    {
		if (!b)
			r = b = buffer_new ();
		else if (b->datasize == b->datamax)
		{
			b->next = buffer_new ();
			b = b->next;
		}
		if (!b)
		{
			/*something really bad just happened!  no choice but to close
			   this connection since it will be out of sync */
			buffer_free (r);
			return 0;
		}
		count = dsize;
		/* dsize could be greater than what is allocated */
		if (count > b->datamax - b->datasize)
			count = b->datamax - b->datasize;
		memcpy (b->data + b->datasize, d, count);
		b->datasize += count;
		dsize -= count;
		d += count;
    }
    return r;
}

/* consume some bytes from the buffer */
BUFFER*
buffer_consume (BUFFER * b, int n)
{
    b->consumed += n;
    if (b->consumed >= b->datasize)
    {
	BUFFER *p = b;

	b = b->next;
//	free (p->data);
	free (p);
    }
    return b;
}

BUFFER *
buffer_append (BUFFER *a, BUFFER *b)
{
    BUFFER *r = a;

    if (!a)
	return b;

    while (a->next)
	a = a->next;
    a->next = b;
    return r;
}

int
buffer_size (BUFFER * b)
{
    int     n = 0;

    for (; b; b = b->next)
	n += b->datasize - b->consumed;
    return n;
}

void
buffer_free (BUFFER * b)
{
    BUFFER *p;

    while (b)
    {
		p = b;
		b = b->next;
//		free (p->data);
		free (p);
    }
}

