#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "netiface.h"

int
#ifdef _WIN32_WCE
WINAPI
WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
#else
main(int argc, char *argv[])
#endif
{
	MXIFACE iface;
	int rc;
	char *dns_list = NULL;
#ifdef _WIN32_WCE
	int	argc;
	char cmdline[256], *argv[32];

	WideCharToMultiByte(CP_ACP, 0, (LPCTSTR)lpCmdLine, 255, cmdline, 256, NULL, NULL);
	argc = split_line(argv+1, 32, cmdline)+1;
#endif

	printf("argc=%d\n", argc);
	if (argc < 6) {
#ifdef _WIN32_WCE
		printf("Usage: netiface_set {1:file} if {1|2:restart} IP netmask [gateway] [DNS]\n");
#else
		printf("Usage: %s {0:active|1:file|2:both} if {1|2:restart} IP netmask [broadcast] [network] [gateway] [DNS]\n",
					argv[0]);
#endif
		exit(-1);
	}
	memset(&iface, 0, sizeof(MXIFACE));
	strcpy(iface.ifname, argv[2]);
	strcpy(iface.ipaddr, argv[4]);
	strcpy(iface.netmask, argv[5]);
#ifdef _WIN32_WCE
	if (argc > 6) strcpy(iface.gateway, argv[6]);
#else
	if (argc > 6) strcpy(iface.broadaddr, argv[6]);
	if (argc > 7) strcpy(iface.network, argv[7]);
	if (argc > 8) strcpy(iface.gateway, argv[8]);
#endif

#ifndef _WIN32_WCE
	if (argv[1][0] == '0' || argv[1][0] == '2') {
		if (mxiface_update_info(&iface) < 0) {
			printf("mxiface_update_info() error\n");
			exit(-2);
		}
		else printf("mxiface_update_info() OK\n");
	}
#endif

	if (argv[1][0] == '1' || argv[1][0] == '2') {
		if ((rc = mxiface_update_interface_file(&iface)) < 0) {
			printf("mxiface_update_interface_file() error %d\n", rc);
			exit(-2);
		}
		else printf("mxiface_update_interface_file() OK\n");
	}

#ifdef _WIN32_WCE
	if (argc > 7) dns_list = argv[7];
#else
	if (argc > 9) dns_list = argv[9];
#endif
	if (dns_list)
	{
	if ((rc = mxhost_update_dns(iface.ifname, dns_list)) < 0)
		printf("mxhost_update_dns() error %d\n", rc);
	else
		printf("mxhost_update_dns() OK\n");
	}

#ifdef _WIN32_WCE
	if (argv[3][0] == '1') mxiface_rebind(argv[2]);
	else if (argv[3][0] == '2') mxiface_restart();
#endif

	return 0;
}
