/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/

#ifndef _MCAST_H
#define _MCAST_H

#ifndef UC711X

#if defined (_WIN32_WCE) || defined (WIN32)
#include <winsock2.h>
#include <ws2tcpip.h>
#else
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if !defined (_WIN32_WCE) && !defined (WIN32)
typedef int SOCKET;
#endif

/*  create a multicast client socket
    Inputs:
        <onoff> the flag to turn on (1) or off (0) multicast packets sent to
				the loopback interface
        <grp> the multicast group
        <port> the multicast port number
        <addr> point to the multicast socket structure
    Outputs: none
    Returns:
        socket fd, otherwise negative on failure
*/
SOCKET
mcast_make_client(int onoff, char *grp, int port, struct sockaddr_in *addr);

/*  create a multicast server socket
    Inputs:
        <grp> the multicast group
        <port> the multicast port number
        <addr> point to the multicast socket structure
    Outputs: none
    Returns:
        socket fd, otherwise negative on failure
*/
SOCKET
mcast_make_server(char *grp, int port, struct sockaddr_in *addr);

/*  join a multicast group
    Inputs:
        <fd> the socket fd
        <grp> the multicast group
        <mreq> point to the multicast request structure
    Outputs: none
    Returns:
		0 on success, -1 on failure
*/
int
mcast_join(SOCKET fd, char *grp, struct ip_mreq *mreq);

/*  leave a multicast group
    Inputs:
        <fd> the socket fd
        <mreq> point to the multicast request structure
    Outputs: none
    Returns:
		0 on success, -1 on failure
*/
int
mcast_leave(SOCKET fd, struct ip_mreq *mreq);

#ifdef __cplusplus
}
#endif

#endif /* UC711X */

#endif /* _MCAST_H */
